function export Main (parameter as string)
    dim n as integer
    dim file as integer
    dim table as integerptr
    dim list as integerptr
    
    ; Note: Our working directory is still the main application directory of battleWarden EX and not the directory the script file is located in.
    file = ReadFile("Scripts\Samples\List\list.txt") 
    if file
        list = CreateList()
          
        while EndOfFile(file) = 0
            table = CreateTable() ; Create a new table.
            
            for n = 0 to 2
              SetString(table, Str(n), ReadString(file))
            next
            
            AddTable(list, table) ; Add the created table to our list.
        wend
    
        ResetListIteration(list) ; Make our list jump before the first table. So there is no current table.
        
        ; NextTable will jump to the next table within our list.
        ; The first time this function is called, our list will jump to the first element and not the second one because of ResetListIteration!
        while NextTable(list) <> 0 
            table = GetTable(list) ; Get the current table in our list.
            
            Debug GetString(table, "0")
            Debug GetString(table, "1")
            Debug GetString(table, "2")
            
            FreeTable(table) ; Delete the current table because we do not need anymore!
        wend
	    
        FreeList(list)
	    
        CloseFile(file)
    endif
endfunction